/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl.textparser;

import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.TagLikeParser;
import eu.pb4.placeholders.api.parsers.TagLikeWrapper;
import eu.pb4.placeholders.impl.textparser.MultiTagLikeParser;
import eu.pb4.placeholders.impl.textparser.SingleTagLikeParser;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public record MergedParser(NodeParser[] parsers) implements NodeParser
{
    public MergedParser(NodeParser[] parsers) {
        ArrayList<NodeParser> list = new ArrayList<NodeParser>(parsers.length);
        ArrayList<Object> combiner = new ArrayList<Object>(4);
        for (NodeParser parser : parsers) {
            if (parser instanceof TagLikeWrapper) {
                TagLikeWrapper wrapper = (TagLikeWrapper)((Object)parser);
                parser = wrapper.asTagLikeParser();
            }
            if (parser instanceof SingleTagLikeParser) {
                SingleTagLikeParser tagLikeParser = (SingleTagLikeParser)parser;
                combiner.add(Pair.of((Object)tagLikeParser.format(), (Object)tagLikeParser.provider()));
                continue;
            }
            if (parser instanceof MultiTagLikeParser) {
                MultiTagLikeParser tagLikeParser = (MultiTagLikeParser)parser;
                combiner.addAll(List.of(tagLikeParser.pairs()));
                continue;
            }
            if (combiner.size() == 1) {
                list.add(new SingleTagLikeParser((TagLikeParser.Format)((Pair)combiner.get(0)).getLeft(), (TagLikeParser.Provider)((Pair)combiner.get(0)).getRight()));
                combiner.clear();
            } else if (combiner.size() > 1) {
                list.add(new MultiTagLikeParser(combiner.toArray(new Pair[0])));
                combiner.clear();
            }
            list.add(parser);
        }
        if (combiner.size() == 1) {
            list.add(new SingleTagLikeParser((TagLikeParser.Format)((Pair)combiner.get(0)).getLeft(), (TagLikeParser.Provider)((Pair)combiner.get(0)).getRight()));
        } else if (combiner.size() > 1) {
            list.add(new MultiTagLikeParser(combiner.toArray(new Pair[0])));
        }
        this.parsers = list.toArray(new NodeParser[0]);
    }

    @Override
    public TextNode[] parseNodes(TextNode input) {
        TextNode[] out = new TextNode[]{input};
        for (int i = 0; i < this.parsers.length; ++i) {
            out = this.parsers[i].parseNodes(TextNode.asSingle(out));
        }
        return out;
    }
}

